<?php

namespace Modules\Video\database\seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Storage;
use Modules\Video\Models\Video;
use Illuminate\Support\Str;

class VideoDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Schema::disableForeignKeyConstraints();


        $avatarPath = config('app.avatar_base_path');

        $videos = [
            [
                'name' => 'Tumse Pyar - Lofi Love Mix',
                'poster_url' => '/dummy-images/video/tumse_pyar_lofi_love_mix.png',
                'poster_tv_url' => '/dummy-images/video/tumse_pyar_lofi_love_mix.png',
                'thumbnail_url' => '/dummy-images/video/tumse_pyar_lofi_love_mix.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'free',
                'IMDb_rating' => NULL,
                'content_rating' => NULL,
                'duration' => Null,
                'release_date' => '2020-02-05',
                'short_desc' => 'Experience the serene and soulful melodies of "Tumse Pyar - Lofi Love Mix," the latest love song perfect for moments of reflection and romance. 🎶❤️',
                'description' => 'Dive into the tranquil vibes of "Tumse Pyar - Lofi Love Mix," a soothing and heartfelt love song that blends gentle rhythms with emotional depth. This latest release is crafted for those cherished moments of intimacy and reflection, offering a perfect backdrop for love and nostalgia. Whether you\'re unwinding after a long day or sharing a quiet evening with someone special, "Tumse Pyar" provides a harmonious escape into the world of lofi beats and tender lyrics. 🎶❤️',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/kXHiIxx2atA?si=BMzFthwqI5t7Ve8j',
                'download_status' => 0,
                'download_url' => NULL,
                'status' => 1,
                'enable_clips' => 1,
            ],
            [
                'name' => 'Heal Your Mind Before You Fix Your Life',
                'poster_url' => '/dummy-images/video/heal/app-videos-heal.jpg',
                'poster_tv_url' => '/dummy-images/video/heal/tv-videos-heal.jpg',
                'thumbnail_url' => '/dummy-images/video/heal/web-videos-heal.jpg',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'paid',
                'plan_id' => 1,
                'IMDb_rating' => NULL,
                'content_rating' => NULL,
                'duration' => Null,
                'release_date' => '2021-06-21',
                'is_restricted' => 0,
                'short_desc' => 'Heal Your Mind Before You Fix Your Life is a compelling motivational speech that inspires you to take control and live your life to the fullest. 🚀🌟',
                'description' => 'In Heal Your Mind Before You Fix Your Life, discover the keys to unlocking your potential and embracing every moment with purpose and passion. This uplifting speech is packed with powerful insights and practical advice that will motivate you to overcome obstacles, chase your dreams, and seize every opportunity that life presents. Whether you\'re looking for a boost in your personal or professional life, "Heal Your Mind" provides the inspiration you need to take action and make the most of your journey. 🚀🌟',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/NGtv92rU0Hg?si=ZllzFTnemBDE73L8',
                'download_status' => 0,
                'download_url' => NULL,
                'status' => 1,
            ],
            [
                'name' => 'A Healthier Life Starts Today',
                'poster_url' => '/dummy-images/video/today/app-videos-today.jpg',
                'poster_tv_url' => '/dummy-images/video/today/tv-videos-today.jpg',
                'thumbnail_url' => '/dummy-images/video/today/web-videos-today.jpg',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'free',
                'IMDb_rating' => NULL,
                'content_rating' => NULL,
                'duration' => Null,
                'release_date' => '2022-03-04',
                'is_restricted' => 0,
                'short_desc' => 'A Healthier Life Starts Today is a breathtaking short video capturing the tranquil beauty of the natural world. 🌿🌅',
                'description' => 'A Healthier Life Starts Today offers a mesmerizing journey through some of the most beautiful and serene landscapes on Earth. This short video captures the essence of nature\'s tranquility, from cascading waterfalls and lush forests to serene sunsets and majestic mountains. With stunning visuals and soothing sounds, Serenity of Nature provides a peaceful escape, allowing viewers to connect with the beauty and calm of the natural world. Perfect for relaxation and mindfulness, this video is a visual treat for nature lovers and anyone seeking a moment of serenity. 🌿🌅🌊',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/668nUCeBHyY?si=SPQ7yT4NVQp0QoW-',
                'download_status' => 0,
                'download_url' => NULL,
                'status' => 1,
                'enable_clips' => 1,
            ],
            [
                'name' => 'Run For Your Life',
                'poster_url' => '/dummy-images/video/run_for_your_life.png',
                'poster_tv_url' => '/dummy-images/video/run_for_your_life.png',
                'thumbnail_url' => '/dummy-images/video/run_for_your_life.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'free',
                'IMDb_rating' => NULL,
                'content_rating' => NULL,
                'duration' => NULL,
                'release_date' => '2023-01-23',
                'is_restricted' => 0,
                'short_desc' => 'A heart-pounding thriller where survival is the only option. 🏃‍♂️💥',
                'description' => 'Run For Your Life is a heart-pounding thriller that follows the protagonist as they navigate a relentless pursuit, where survival is the only option. With every twist and turn, the stakes get higher, and the chase becomes more intense. This gripping tale of endurance and courage will keep you on the edge of your seat from start to finish. 🏃‍♂️💥',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/79Sd4GtOXuI?si=kgtBwn0Riw_TcvdX',
                'download_status' => 0,
                'download_url' => NULL,
                'status' => 1,
                'enable_clips' => 1,
            ],
            [
                'name' => 'Spiritual Habits for a Calm Mind',
                'poster_url' => '/dummy-images/video/mind/app-videos-mind.jpg',
                'poster_tv_url' => '/dummy-images/video/mind/tv-videos-mind.jpg',
                'thumbnail_url' => '/dummy-images/video/mind/web-videos-mind.jpg',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'free',
                'IMDb_rating' => NULL,
                'content_rating' => NULL,
                'duration' => NULL,
                'release_date' => '2024-04-18',
                'is_restricted' => 1,
                'short_desc' => 'Embark on a thrilling journey through the urban jungle, filled with surprises and new encounters. 🏙️🌟',
                'description' => 'Spiritual Habits for a Calm Mind takes viewers on an exhilarating adventure through the bustling urban landscape. Follow a spirited protagonist as they navigate crowded streets, discover hidden gems, and forge unexpected friendships along the way. This vibrant video captures the essence of exploration and discovery in the heart of the city, promising excitement and heartwarming moments for all who embark on this journey. 🏙️🌟',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/mYfJxlgR2jw?si=uQgarqR0VJvdfUd5',
                'download_status' => 0,
                'download_url' => NULL,
                'status' => 1,
                'enable_clips' => 1,
            ],
            [
                'name' => 'Echoes of Valor',
                'poster_url' => '/dummy-images/video/echoes_of_valor.png',
                'poster_tv_url' => '/dummy-images/video/echoes_of_valor.png',
                'thumbnail_url' => '/dummy-images/video/echoes_of_valor.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'free',
                'IMDb_rating' => NULL,
                'content_rating' => NULL,
                'duration' => '01:20',
                'release_date' => '2024-04-19',
                'is_restricted' => 0,
                'short_desc' => 'Echoes of Valor depicts the intense and emotional journey of a sniper and his spotter during the Indo-Pak War, facing moral conflicts in their pursuit of the enemy. 🎬🏅',
                'description' => 'Echoes of Valor brings to life the harrowing experiences of two Indian Army soldiers—a sniper and his spotter—during the Indo-Pak War. The film captures their inner turmoil as they confront their foes and wrestle with the ethical implications of their mission. A powerful thriller with a stirring musical score, it offers a profound reflection on the nature of conflict and bravery. 🎖️🌟',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/JEKCMP3w9zs?si=psaIC0wKC3akDOqp',
                'download_status' => 0,
                'download_url' => NULL,
                'status' => 1,
                'enable_clips' => 1,
            ],
            [
                'name' => 'Victory Vibes',
                'poster_url' => '/dummy-images/video/victoryvibes/app-home-vibe.jpg',
                'poster_tv_url' => '/dummy-images/video/victoryvibes/tv-home-vibe.jpg', 
                'thumbnail_url' => '/dummy-images/video/victoryvibes/web-home-vibe.jpg',
                'trailer_url_type' => 'YouTube',    
                'trailer_url' => null,
                'access' => 'pay-per-view',
                'price' => 10,
                'purchase_type' => 'rental',
                'access_duration' => 5,
                'discount' => 10,
                'available_for' => 20,
                'IMDb_rating' => NULL,
                'content_rating' => NULL,
                'duration' => '00:50',
                'release_date' => '2024-04-20',
                'is_restricted' => 0,
                'short_desc' => 'Get inspired by quick, uplifting videos celebrating athletes\' perseverance, grit, and determination in overcoming challenges. 🌟🏅',
                'description' => 'Victory Vibes brings you bite-sized, motivational videos showcasing the incredible stories of athletes who triumph against the odds. Whether it’s the underdog story, the road to recovery, or pushing past limits, these short clips will inspire you to chase your dreams. Watch, feel the adrenaline, and fuel your passion for greatness! 💪🏆',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/seSCvuejudM?si=v7SdVilWIM1Niqid',
                'download_status' => 0,
                'download_url' => NULL,
                'status' => 1,
                'enable_clips' => 1,
            ],
            [
                'name' => 'Midnight Thrills',
                'poster_url' => '/dummy-images/video/midnight_thrills.png',
                'poster_tv_url' => '/dummy-images/video/midnight_thrills.png',
                'thumbnail_url' => '/dummy-images/video/midnight_thrills.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'pay-per-view',
                'price' => 10,
                'purchase_type' => 'rental',
                'access_duration' => 5,
                'discount' => 10,
                'available_for' => 20,
                'IMDb_rating' => NULL,
                'content_rating' => NULL,
                'duration' => '00:45',
                'release_date' => '2024-04-21',
                'is_restricted' => 0,
                'short_desc' => 'Dive into spine-chilling suspense with brief, gripping thriller shorts that keep you on the edge of your seat. 🌙🔍',
                'description' => 'Midnight Thrills offers a collection of intense, suspenseful short films that will captivate and thrill you in just a few minutes. Each video is a meticulously crafted suspense thriller that delivers unexpected twists, dark mysteries, and nail-biting moments. Perfect for when you crave a quick dose of excitement and intrigue. Get ready for a thrilling experience under the cover of night! 🎬🕵️‍♂️',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/VHenrR4ledY?si=PCHvpjq4t9zpaJim',
                'download_status' => 0,
                'download_url' => NULL,
                'status' => 1,
                'enable_clips' => 1,
            ],
            [
                'name' => 'Hearts Entwined',
                'poster_url' => '/dummy-images/video/hearts_entwined.png',
                'poster_tv_url' => '/dummy-images/video/hearts_entwined.png',
                'thumbnail_url' => '/dummy-images/video/hearts_entwined.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'pay-per-view',
                'price' => 40,
                'purchase_type' => 'onetime',
                'discount' => 10,
                'available_for' => 20,
                'plan_id'=>null,
                'IMDb_rating' => NULL,
                'content_rating' => NULL,
                'duration' => '01:20',
                'release_date' => '2024-04-24',
                'is_restricted' => 0,
                'short_desc' => 'Experience the magic of romance with heartwarming short videos that capture the essence of love and connection. 💖🎥',
                'description' => 'Hearts Entwined presents a series of romantic short films that delve into the many facets of love and relationships. Featuring captivating stories and touching moments, each video is designed to make you feel the joy, passion, and tenderness of romance. Whether it\'s a sweet love story or a heartfelt confession, these shorts will leave you inspired and in love with the idea of finding that special connection. Let each film whisk you away on a romantic journey! 🌹✨',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/22l6w8n9iCc?si=Gr7MTCfEs9xf6pvz',
                'download_status' => 0,
                'download_url' => NULL,
                'status' => 1,
                'enable_clips' => 1,
            ],
            [
                'name' => 'Gnomeo\'s Love Stories',
                'poster_url' => '/dummy-images/video/gnomeos_love_stories.png',
                'poster_tv_url' => '/dummy-images/video/gnomeos_love_stories.png',
                'thumbnail_url' => '/dummy-images/video/gnomeos_love_stories.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'paid',
                'plan_id'=>1,
                'IMDb_rating' => NULL,
                'content_rating' => NULL,
                'duration' => '00:50',
                'release_date' => '2024-04-26',
                'is_restricted' => 0,
                'short_desc' => 'Explore charming, whimsical tales of love and adventure with garden gnomes in this delightful collection of short romantic videos. 🌹',
                'description' => 'Gnomeo\'s Love Stories brings you enchanting short videos featuring the adorable garden gnomes Gnomeo and Juliet. Follow their heartwarming adventures and romantic escapades as they navigate the ups and downs of love amidst whimsical lawn decorations, quirky neighbors, and playful antics. Each video is a perfect blend of romance and fun, capturing the essence of finding love in the most unexpected places. Immerse yourself in these miniature love stories and experience a world where love always wins, no matter the obstacles. 🌟❤️',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/9ucSt-naGZ0?si=fo-r7wQuJ6Exi1RX',
                'download_status' => 0,
                'download_url' => NULL,
                'status' => 1,
                'enable_clips' => 1,
            ],
            [
                'name' => 'Warrior\'s Dilemma',
                'poster_url' => '/dummy-images/video/warriors_dilemma.png',
                'poster_tv_url' => '/dummy-images/video/warriors_dilemma.png',
                'thumbnail_url' => '/dummy-images/video/warriors_dilemma.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'paid',
                'plan_id' => 1,
                'IMDb_rating' => NULL,
                'duration' => '00:20',
                'release_date' => '2024-04-30',
                'is_restricted' => 0,
                'short_desc' => 'A brave team of young warriors embarks on an epic quest to save their world from dark forces in this action-packed animated adventure. 💥🛡️🔥',
                'description' => '"Warrior\'s Dilemma" presents a compelling story of two soldiers in the Indo-Pak War—one a sniper, the other his spotter—who face profound moral challenges as they hunt their enemies. The film is a gripping blend of thriller and drama, enhanced by a powerful soundtrack that underscores the film\'s exploration of courage, morality, and the costs of war. 🎖️🎵',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/Q23gKyHWjjg?si=wK6AqYlE9P9-bdXS',
                'download_status' => 0,
                'download_url' => NULL,
                'status' => 1,
                'enable_clips' => 1,    
            ],
            [
                'name' => 'Everyday Comedy Gems',
                'poster_url' => '/dummy-images/video/everyday_comedy_gems.png',
                'poster_tv_url' => '/dummy-images/video/everyday_comedy_gems.png',
                'thumbnail_url' => '/dummy-images/video/everyday_comedy_gems.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'paid',
                'plan_id' => 2,
                'IMDb_rating' => NULL,
                'duration' => '00:50',
                'release_date' => '2024-05-01',
                'is_restricted' => 0,
                'short_desc' => 'Dive into hilariously mundane moments transformed into remarkable comedy in these short videos. 😂🎬',
                'description' => '"Everyday Comedy Gems" presents a collection of short videos that turn the most ordinary situations into extraordinary laughs. Watch as everyday mishaps, small surprises, and routine moments become the heart of whimsical comedy. From unremarkable beginnings to uproarious endings, each video captures the essence of finding humor in the mundane. Enjoy a fresh take on life\'s little quirks and laugh along with characters who prove that comedy can be found in the most unexpected places. Get ready for a series of delightful, laugh-out-loud moments that bring a touch of magic to the ordinary. 🌟🤣🎉',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/sxCWB47ZCLQ?si=jCVwFRmmQ2lLyc1_',
                'download_status' => 0,
                'download_url' => NULL,
                'status' => 1,
            ],
            [
                'name' => 'Exorcism Trials',
                'poster_url' => '/dummy-images/video/exorcism_trials.png',
                'poster_tv_url' => '/dummy-images/video/exorcism_trials.png',
                'thumbnail_url' => '/dummy-images/video/exorcism_trials.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'paid',
                'plan_id' => 2,
                'IMDb_rating' => NULL,
                'duration' => '00:45',
                'release_date' => '2024-05-14',
                'is_restricted' => 0,
                'short_desc' => 'Follow Sister Ann\'s journey as she battles demonic forces and uncovers dark secrets in these chilling short videos. 😈📽️',
                'description' => '"Exorcism Trials" delves into the spine-tingling world of spiritual warfare with a series of gripping short videos. Watch as Sister Ann, a pioneering female exorcist, faces the ultimate test of faith and courage. Trained in a newly reopened exorcism school, Ann confronts her own past demons and engages in intense battles with malevolent forces. Each video intensifies the suspense as she confronts the sinister entity tormenting a young girl and discovers a deeper, more personal connection to the evil she faces. Experience the tension, fear, and spiritual struggle in these hauntingly immersive clips. 🌌😱🕯️',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/zlpfcKffgDA?si=hABQwDuaOho53ayQ',
                'download_status' => 0,
                'download_url' => NULL,
                'status' => 1,
            ],
            [
                'name' => 'Deep Sleep Music for Dogs',
                'poster_url' => '/dummy-images/video/deep_sleep_music_for_dogs.png',
                'poster_tv_url' => '/dummy-images/video/deep_sleep_music_for_dogs.png',
                'thumbnail_url' => '/dummy-images/video/deep_sleep_music_for_dogs.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'paid',
                'plan_id' => 2,
                'IMDb_rating' => NULL,
                'duration' => '01:20',
                'release_date' => '2024-05-25',
                'is_restricted' => 1,
                'short_desc' => 'Relax your furry friend with calming music that helps them drift into deep sleep within minutes. 🐕💤',
                'description' => '"Deep Sleep Music for Dogs" is the ultimate sound therapy for your pets, designed to help them fall asleep in just 5 minutes! Whether it\'s a playful puppy who needs extra rest or an adult dog who enjoys a quiet nap, this soothing music will relax them instantly. Dogs naturally need plenty of sleep, with adult dogs sleeping 12–14 hours per day and puppies up to 18 hours or more. Turn on this calming track, watch how they respond, and ensure they get the peaceful rest they deserve. 🐶🎵💤',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://www.youtube.com/live/hD6DzC585bw?si=7XpEHjOV2fFNYFoX',
                'download_status' => 0,
                'download_url' => NULL,
                'status' => 1,
            ],
            [
                'name' => 'School Hacks & Fun DIY Crafts',
                'poster_url' => '/dummy-images/video/school_hacks_fun_diy_crafts.png',
                'poster_tv_url' => '/dummy-images/video/school_hacks_fun_diy_crafts.png',
                'thumbnail_url' => '/dummy-images/video/school_hacks_fun_diy_crafts.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'paid',
                'plan_id' => 2,
                'IMDb_rating' => NULL,
                'duration' => '00:50',
                'release_date' => '2024-06-08',
                'is_restricted' => 1,
                'short_desc' => 'Discover amazing school hacks and easy DIY crafts that will make your school life easier and more fun! ✂️📚',
                'description' => '"School Hacks & Fun DIY Crafts" is the ultimate guide to transforming your school experience with creative tips and projects. Whether you need to stay organized, personalize your supplies, or just have fun with unique crafts, this video covers it all. From clever study tips to imaginative DIY projects, it’s designed to make your school days more enjoyable and efficient. Grab your supplies and get ready to craft your way to a better school experience! 🎒✏️📐',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/yG0W82PGAcQ?si=a2PSqhYHCP5ooUdI',
                'download_status' => 0,
                'download_url' => NULL,
                'status' => 1,
            ],
            [
                'name' => 'Your Morning Shapes Your Destiny',
                'poster_url' => '/dummy-images/video/destiny/app-videos-destiny.jpg',
                'poster_tv_url' => '/dummy-images/video/destiny/tv-videos-destiny.jpg',
                'thumbnail_url' => '/dummy-images/video/destiny/web-videos-destiny.jpg',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'paid',
                'plan_id' => 3,
                'IMDb_rating' => NULL,
                'duration' => '00:40',
                'release_date' => '2024-06-17',
                'is_restricted' => 0,
                'short_desc' => 'Join this 30-minute beginner yoga session to improve flexibility, build strength, and calm your mind. Perfect for those new to yoga or wanting a mindful pace! 🧘‍♂️✨',
                'description' => '"Your Morning Shapes Your Destiny" is the perfect introduction to a sustainable and enjoyable yoga practice. In this 30-minute session, we\'ll focus on breath control, foundational poses, and proper form to boost flexibility, build strength, and regulate your nervous system. Designed for beginners or those seeking a slower, mindful approach, this class helps you connect with your breath and body. Yoga is for everyone, and the hardest part is just showing up—repeat this session regularly and watch your body transform! 🌱🧘‍♂️💪',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/AB3Y-4a3ZrU?si=ATa2_GU_Xgesw50D',
                'download_status' => 0,
                'download_url' => NULL,
                'status' => 1,
            ],
            [
                'name' => 'The Madness Within',
                'poster_url' => '/dummy-images/video/the_madness_within.png',
                'poster_tv_url' => '/dummy-images/video/the_madness_within.png',
                'thumbnail_url' => '/dummy-images/video/the_madness_within.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'paid',
                'plan_id' => 3,
                'IMDb_rating' => NULL,
                'duration' => '00:30',
                'release_date' => '2024-06-23',
                'is_restricted' => 0,
                'short_desc' => 'Arthur Fleck, institutionalized at Arkham, faces inner turmoil while discovering love and music. 🎭🖤',
                'description' => '"Joker: The Madness Within" finds Arthur Fleck trapped in Arkham Asylum, struggling to reconcile his identity as Joker. Awaiting trial, Arthur’s mental chaos intertwines with moments of unexpected beauty—true love and music that awakens something deep inside him. This short film delves into the complexity of madness, love, and creativity within Gotham\'s most infamous villain. A haunting blend of emotion and turmoil awaits. 🎵🃏🎶',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/_OKAwz2MsJs?si=3MJoVxwaxLSLvBXT',
                'download_status' => 0,
                'download_url' => NULL,
                'status' => 1,
            ],
            [
                'name' => 'Big Style on a Small Budget',
                'poster_url' => '/dummy-images/video/big_style_on_a_small_budget.png',
                'poster_tv_url' => '/dummy-images/video/big_style_on_a_small_budget.png',
                'thumbnail_url' => '/dummy-images/video/big_style_on_a_small_budget.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'paid',
                'plan_id' => 3,
                'IMDb_rating' => NULL,
                'duration' => '00:20',
                'release_date' => '2024-06-25',
                'is_restricted' => 0,
                'short_desc' => 'Transform your space with easy, affordable home makeover ideas that add character and style—perfect for renters! 🏡✨',
                'description' => 'Discover thoughtful and affordable room makeover tips that can completely transform your home, whether you\'re a renter or a homeowner. From small weekend projects to clever design ideas, these simple upgrades will make a big impact on the character and style of your living space. If you\'re feeling stuck, financially strained, or short on time for big DIY projects, this video offers creative solutions to elevate your home without breaking the bank. Get ready to be inspired and make your home feel thoughtfully designed! 🛋️🖼️💡',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/xOiXbP5QIrM?si=5re4hT1YH8n2fPv6',
                'download_status' => 0,
                'download_url' => NULL,
                'status' => 1,
            ],
            [
                'name' => 'Ultimate Kitchen Organization',
                'poster_url' => '/dummy-images/video/ultimate_kitchen_organization.png',
                'poster_tv_url' => '/dummy-images/video/ultimate_kitchen_organization.png',
                'thumbnail_url' => '/dummy-images/video/ultimate_kitchen_organization.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'paid',
                'plan_id' => 4,
                'IMDb_rating' => NULL,
                'duration' => '01:20',
                'release_date' => '2024-06-30',
                'is_restricted' => 0,
                'short_desc' => 'Discover budget-friendly kitchen organization tips that will transform your space! Clean, restock, and organize for a more efficient and satisfying kitchen experience. 🧼🍲🛒',
                'description' => '"Ultimate Kitchen Organization" is your go-to guide for transforming your kitchen into a clean and efficient space on a budget. This video is packed with satisfying cleaning routines, restocking ideas, and clever organizing hacks that will help you declutter and streamline your kitchen. From pantry organization to refrigerator restocking, you\'ll learn practical tips that make your kitchen more functional without breaking the bank. Watch how these simple yet effective ideas can elevate your kitchen and make cooking an enjoyable, stress-free experience! 🍳🧺🌿',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/ZYmV65FYmYY?si=4-eWG9WbXQBmOhDk',
                'download_status' => 0,
                'download_url' => NULL,
                'status' => 1,
            ],
            [
                'name' => 'Life Changing Fitness Habits - Daily Healthy Tips',
                'poster_url' => '/dummy-images/video/life_changing_fitness_habits_daily_healthy_tips.png',
                'poster_tv_url' => '/dummy-images/video/life_changing_fitness_habits_daily_healthy_tips.png',
                'thumbnail_url' => '/dummy-images/video/life_changing_fitness_habits_daily_healthy_tips.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'paid',
                'plan_id' => 4,
                'status' => 1,
                'IMDb_rating' => NULL,
                'duration' => '00:45',
                'release_date' => '2024-07-03',
                'is_restricted' => 0,
                'short_desc' => 'Discover practical and achievable fitness tips to enhance your daily health routine! Start making well-being a priority and share these life-changing habits with friends! 🌿💪',
                'description' => '"Life-Changing Fitness Habits" is here to help you become the best version of yourself with simple, scientifically-backed tips that are easy to follow. Our goal is to promote good health and well-being, making the world a healthier place one habit at a time! From fitness hacks to daily healthy tips, these five powerful habits will revolutionize your approach to fitness and wellness. Whether you’ve heard them before or they surprise you, implementing these tips will help you live a balanced and healthier life. 🌟🏋️‍♀️🌿 Get ready to transform your routine and inspire those around you!',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/YNsuneGBsMY?si=AARfxbPatjTITtba',
                'download_status' => 0,
                'download_url' => NULL,
            ],
            [
                'name' => 'Motel of Nightmares',
                'poster_url' => '/dummy-images/video/motel_of_nightmares.png',
                'poster_tv_url' => '/dummy-images/video/motel_of_nightmares.png',
                'thumbnail_url' => '/dummy-images/video/motel_of_nightmares.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'paid',
                'plan_id' => 4,
                'status' => 1,
                'IMDb_rating' => NULL,
                'duration' => '01:20',
                'release_date' => '2024-07-06',
                'is_restricted' => 0,
                'short_desc' => 'Dive into a series of chilling short videos where a woman fights to escape a hellish motel haunted by a relentless monster. 🏚️😨',
                'description' => '"Motel of Nightmares" unfolds a terrifying tale through a collection of gripping short videos. Watch as an exhausted woman, trapped in a decrepit motel, battles her worst fears. Each video delves deeper into her nightmarish reality, where every creak and shadow hints at the monstrous terror stalking her. From eerie encounters and broken glass to a fateful confrontation in her car, these videos capture the essence of a horror that blurs the line between nightmare and reality. Experience the tension and dread as the woman faces a relentless, hellish monster in a race for survival. 🌌👻🔪',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/x2c39v5NMj4?si=B-j6ex_SNm3Y03g1',
                'download_status' => 0,
                'download_url' => NULL,
            ],

            [
                'name' => 'Flapping Origami Bat Fun',
                'poster_url' => '/dummy-images/video/flapping_origami_bat_fun.png',
                'poster_tv_url' => '/dummy-images/video/flapping_origami_bat_fun.png',
                'thumbnail_url' => '/dummy-images/video/flapping_origami_bat_fun.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'paid',
                'plan_id' => 4,
                'status' => 1,
                'IMDb_rating' => NULL,
                'duration' => '00:50',
                'release_date' => '2024-07-10',
                'is_restricted' => 1,
                'short_desc' => 'Create an origami bat that flaps its wings! Perfect for Halloween décor or playful scares. 🦇🎃',
                'description' => '"Flapping Origami Bat Fun" is your guide to making a spooky, flapping origami bat that’s easy to craft and perfect for Halloween. Learn how to create this fun paper toy that flaps its wings with a simple click. Ideal for Halloween decorations or playful pranks, these bats can also be used to make garlands or window dressings. Get crafty and add a touch of spooky fun to your home! 🦇🖤✂️',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/kBJGchWe6uU?si=TA0UtKGFhSqWY8lj',
                'download_status' => 0,
                'download_url' => NULL,
            ],

            [
                'name' => 'Nordic Forest Calm: Music for Relaxation',
                'poster_url' => '/dummy-images/video/nordic_forest_calm_music_for_relaxation.png',
                'poster_tv_url' => '/dummy-images/video/nordic_forest_calm_music_for_relaxation.png',
                'thumbnail_url' => '/dummy-images/video/nordic_forest_calm_music_for_relaxation.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'paid',
                'plan_id' => 4,
                'status' => 1,
                'IMDb_rating' => NULL,
                'duration' => '01:20',
                'release_date' => '2024-07-16',
                'is_restricted' => 1,
                'short_desc' => 'Unwind with soothing Nordic forest ambience and relaxing music for stress relief, calm, and focus. 🌲🎶',
                'description' => '"Nordic Forest Calm: Music for Relaxation" combines calming nature sounds of rustling leaves and distant bird songs with tranquil music to help you relax, focus, and relieve stress. Perfect for studying, meditating, or unwinding after a long day, this video creates a peaceful ambience that transports you to a serene Nordic forest. Let the soothing sounds guide you to a state of calm and relaxation. 🌿🎧🍃',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/3eP0s8sg1n8?si=PuIU-x43XiR7XyzQ',
                'download_status' => 0,
                'download_url' => NULL,
            ],

            [
                'name' => 'Mango Mousse Delight',
                'poster_url' => '/dummy-images/video/mango_mousse_delight.png',
                'poster_tv_url' => '/dummy-images/video/mango_mousse_delight.png',
                'thumbnail_url' => '/dummy-images/video/mango_mousse_delight.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'pay-per-view',
                'price' => 10,
                'purchase_type' => 'rental',
                'access_duration' => 5,
                'discount' => 10,
                'available_for' => 20,
                'plan_id' => NULL,
                'status' => 1,
                'IMDb_rating' => NULL,
                'duration' => '00:50',
                'release_date' => '2024-07-27',
                'is_restricted' => 0,
                'short_desc' => 'Indulge in the deliciousness of this 3-layer Mango Mousse Cake! Learn how to make this refreshing dessert and impress your taste buds. 😋🍰🥭',
                'description' => '"Mango Mousse Delight" is a step-by-step guide to making a scrumptious 3-layer Mango Mousse Cake. Learn how to prepare a soft sponge base, layer rich and creamy mousse, and create a dessert that’s as delightful as it is refreshing. This easy-to-follow recipe is perfect for bakers of all levels and is sure to impress your guests. Make your next occasion extra special with this delightful mango mousse cake! 🍰🥭✨😋',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/4TUgTat4lg8?si=fC1r5EVueVXYV9uq',
                'download_status' => 0,
                'download_url' => NULL,
            ],
            [
                'name' => 'The Power of Words | This Story Will Change Your Life',
                'poster_url' => '/dummy-images/video/the_power_of_words_this_story_will_change_your_life.png',
                'poster_tv_url' => '/dummy-images/video/the_power_of_words_this_story_will_change_your_life.png',
                'thumbnail_url' => '/dummy-images/video/the_power_of_words_this_story_will_change_your_life.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'pay-per-view',
                'price' => 40,
                'purchase_type' => 'onetime',
                'discount' => 10,
                'available_for' => 20,
                'plan_id' => NULL,
                'status' => 1,
                'IMDb_rating' => NULL,
                'duration' => '00:20',
                'release_date' => '2024-08-01',
                'is_restricted' => 0,
                'short_desc' => 'Discover the profound impact of words! This life-changing story will teach you how to use your words wisely and inspire positive change in yourself and others. 💬🌟',
                'description' => '"The Power of Words" is a transformative story that will open your eyes to the incredible influence words hold. 📖✨ Learn how to use your words wisely to inspire, uplift, and make a lasting difference in your life and the lives of those around you. Whether you\'re communicating with loved ones or strangers, this story reveals the importance of choosing your words carefully and positively. 💬🌟 Tune in, reflect, and embrace the change that wise communication can bring!',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/Sp503K6iPCg?si=VKSZrB7Bfam2fWeV',
                'download_status' => 0,
                'download_url' => NULL,
            ],

            [
                'name' => 'Healthy Homemade Diet Plan | Effective Weight Loss at Home',
                'poster_url' => '/dummy-images/video/healthy_homemade_diet_plan_effective_weight_loss_at_home.png',
                'poster_tv_url' => '/dummy-images/video/healthy_homemade_diet_plan_effective_weight_loss_at_home.png',
                'thumbnail_url' => '/dummy-images/video/healthy_homemade_diet_plan_effective_weight_loss_at_home.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'pay-per-view',
                'price' => 40,
                'purchase_type' => 'onetime',
                'discount' => 10,
                'available_for' => 20,
                'plan_id' => NULL,
                'status' => 1,
                'IMDb_rating' => NULL,
                'duration' => '01:20',
                'release_date' => '2024-08-06',
                'is_restricted' => 0,
                'short_desc' => 'Discover a healthy and effective diet plan with homemade foods! 🥗🍽️ Perfect for weight loss and maintaining wellness from the comfort of your home. 🏠💪',
                'description' => '"Diet Plan with Homemade Foods" offers a comprehensive guide to a nutritious and effective weight loss meal plan using ingredients you have at home. 🍎🥑 From breakfast ideas to dinner recipes, learn how to prepare balanced meals that support your weight loss goals while keeping your taste buds satisfied. 🌟💪 This video will provide you with practical tips, delicious recipes, and meal prep strategies to help you stay on track and achieve your health objectives. Cook up a healthier you with these easy and effective homemade food options!',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/_2tgrajiXG0?si=7XxWoBwTsBunnNx2',
                'download_status' => 0,
                'download_url' => NULL,
            ],

            [
                'name' => 'Beautiful Rangoli Designs',
                'poster_url' => '/dummy-images/video/beautiful_rangoli_designs.png',
                'poster_tv_url' => '/dummy-images/video/beautiful_rangoli_designs.png',
                'thumbnail_url' => '/dummy-images/video/beautiful_rangoli_designs.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'pay-per-view',
                'price' => 10,
                'purchase_type' => 'rental',
                'access_duration' => 5,
                'discount' => 10,
                'available_for' => 20,
                'plan_id' => NULL,
                'status' => 1,
                'IMDb_rating' => NULL,
                'duration' => '00:45',
                'release_date' => '2024-08-09',
                'is_restricted' => 0,
                'short_desc' => 'Immerse yourself in the art of Rangoli with this satisfying video showcasing stunning designs! 🎨🌼 Perfect for inspiration and relaxation. 🌟',
                'description' => '"Satisfying Rangoli Designs" features a collection of beautiful and intricate Rangoli patterns that are both visually stunning and satisfying to watch. 🌸✨ Discover creative designs and traditional techniques as we guide you through the process of creating vibrant and elegant Rangoli art. Whether you\'re a seasoned artist or a beginner looking for inspiration, this video will provide you with a soothing and artistic experience. 🖼️💫 Perfect for enhancing your festive decor or simply enjoying the beauty of this traditional craft. Get ready to be inspired and amazed by the beauty of Rangoli!',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/rZeu5iz_N7k?si=_ePcaoBZqLCGhGmC',
                'download_status' => 0,
                'download_url' => NULL,
            ],

            [
                'name' => 'Catcalls: The Haunting',
                'poster_url' => '/dummy-images/video/catcalls_the_haunting.png',
                'poster_tv_url' => '/dummy-images/video/catcalls_the_haunting.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'pay-per-view',
                'price' => 10,
                'purchase_type' => 'rental',
                'access_duration' => 5,
                'discount' => 10,
                'available_for' => 20,
                'plan_id' => NULL,
                'status' => 1,
                'IMDb_rating' => NULL,
                'duration' => '00:50',
                'release_date' => '2024-08-13',
                'is_restricted' => 0,
                'short_desc' => 'Experience chilling short videos where street harassment takes a horrifying twist as predators become the prey in a night of terror. 👻🔪',
                'description' => '"Catcalls: The Haunting" brings a disturbing twist to street harassment through a series of gripping short videos. Follow a man cruising late at night who encounters two seemingly innocent girls. However, his attempt to get a thrill by flashing them turns into a nightmare when he discovers they are on their own hunt. This series explores the unsettling themes of harassment and power dynamics, shifting the predator-prey relationship in a spine-chilling narrative. The videos showcase a fictional horror where the tables are turned, revealing the true horror of becoming the hunted. Dive into a world where safety is an illusion and danger lurks in every corner.',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/4jytFeNxsdo?si=euMe_ms5UtU42fRM',
                'download_status' => 0,
                'download_url' => NULL,
            ],

            [
                'name' => 'Ultimate Kitchen Organization Hacks',
                'poster_url' => '/dummy-images/video/ultimate_kitchen_organization_hacks.png',
                'poster_tv_url' => '/dummy-images/video/ultimate_kitchen_organization_hacks.png',
                'thumbnail_url' => '/dummy-images/video/ultimate_kitchen_organization_hacks.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'pay-per-view',
                'price' => 40,
                'purchase_type' => 'onetime',
                'discount' => 10,
                'available_for' => 20,
                'plan_id' => NULL,
                'status' => 1,
                'IMDb_rating' => NULL,
                'duration' => '00:45',
                'release_date' => '2024-08-18',
                'is_restricted' => 0,
                'short_desc' => 'Maximize your small kitchen space with these 10 smart organization hacks for a clutter-free and efficient cooking area. 🍽️✨',
                'description' => '"Ultimate Kitchen Organization Hacks" provides practical and space-saving solutions to optimize even the smallest kitchens. From clever storage ideas to easy DIY fixes, these tips will help you create a clutter-free, efficient kitchen where everything has its place. Whether you\'re dealing with tight cabinets or limited counter space, these hacks will make your cooking area more functional and stylish. Perfect for anyone looking to simplify and enhance their kitchen setup!',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/ZYmV65FYmYY?si=EOk5cwoafiTxn1qA',
                'download_status' => 0,
                'download_url' => NULL,
            ],

            [
                'name' => 'Morning Bliss Routine',
                'poster_url' => '/dummy-images/video/morning_bliss_routine.png',
                'poster_tv_url' => '/dummy-images/video/morning_bliss_routine.png',
                'thumbnail_url' => '/dummy-images/video/morning_bliss_routine.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'free',
                'plan_id' => NULL,
                'status' => 1,
                'IMDb_rating' => NULL,
                'duration' => '01:50',
                'release_date' => '2024-08-25',
                'is_restricted' => 0,
                'short_desc' => 'A holiday morning routine designed to help you wake up early and start your day with positivity and calm. 🌅⛅️',
                'description' => '"6 AM Morning Bliss Routine" follows a former office worker in her 30s as she shares her peaceful and energizing holiday morning routine. This uplifting routine will inspire you to wake up early and create a pleasant start to your week. From gentle stretches to a refreshing breakfast, every step is designed to help you feel balanced, productive, and excited about your day. Perfect for anyone looking for an easy yet impactful morning routine!',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/otpa3LqonSs?si=DmohFhBQF8eClmdG',
                'download_status' => 0,
                'download_url' => NULL,
            ],
            [
                'name' => 'Genius Home Hacks for Effortless Living',
                'poster_url' => '/dummy-images/video/genius_home_hacks_for_effortless_living.png',
                'poster_tv_url' => '/dummy-images/video/genius_home_hacks_for_effortless_living.png',
                'thumbnail_url' => '/dummy-images/video/genius_home_hacks_for_effortless_living.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'free',
                'plan_id' => NULL,
                'status' => 1,
                'IMDb_rating' => NULL,
                'duration' => '01:20',
                'release_date' => '2024-09-04',
                'is_restricted' => 0,
                'short_desc' => 'Transform your daily routine with these genius home hacks! From cleaning and organizing to cooking and DIY, life just got easier. 😎✨',
                'description' => '"Genius Home Hacks for Effortless Living" is your ultimate guide to making life easier at home! This video showcases a collection of mind-blowing tips and tricks that simplify everything from cleaning and organizing to cooking and DIY projects. Discover simple yet effective solutions that will save you time and energy, whether you’re tidying up your space or preparing a quick meal. Make everyday tasks a breeze with these creative hacks! Don’t forget to hit that like button, leave a comment with your favorite hack, and subscribe for more amazing content. 🎉🏡💡',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/Gfn_lik3eE8?si=k-2Cp3R_2dRxam95',
                'download_status' => 0,
                'download_url' => NULL,
            ],
            [
                'name' => 'Become Your Best Self',
                'poster_url' => '/dummy-images/video/become_your_best_self.png',
                'poster_tv_url' => '/dummy-images/video/become_your_best_self.png',
                'thumbnail_url' => '/dummy-images/video/become_your_best_self.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'free',
                'plan_id' => NULL,
                'status' => 1,
                'IMDb_rating' => NULL,
                'duration' => '00:50',
                'release_date' => '2024-09-07',
                'is_restricted' => 0,
                'short_desc' => 'Get inspired by powerful speeches! 🎯 Hear the words that will motivate you to focus on self-growth and becoming better than your previous self, not others. 💪✨',
                'description' => '"Life-Changing Speeches You Need to Hear TODAY" brings you the best motivational messages that will push you to strive for personal growth and self-improvement. 🌟 The goal is not to compete with others, but to surpass the person you were yesterday. 🌱 These speeches will ignite a spark in you to focus on inner strength, resilience, and the journey to becoming the best version of yourself. 🎤💪 Watch, reflect, and take the first step toward positive change today!',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/DfY7rRQXf3M?si=a3CDJaUDnfz1o1Rd',
                'download_status' => 0,
                'download_url' => NULL,
            ],
            [
                'name' => 'Potato Perfection',
                'poster_url' => '/dummy-images/video/potato_perfection.png',
                'poster_tv_url' => '/dummy-images/video/potato_perfection.png',
                'thumbnail_url' => '/dummy-images/video/potato_perfection.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'free',
                'plan_id' => NULL,
                'status' => 1,
                'IMDb_rating' => NULL,
                'duration' => '00:20',
                'release_date' => '2024-09-08',
                'is_restricted' => 0,
                'short_desc' => 'Discover amazing potato recipes, from crispy French fries to savory potato sticks! Elevate your snack game with these easy and delicious ideas. 🍟🤩',
                'description' => '"Potato Perfection" is your ultimate guide to mastering all things potato! This video features a collection of mouth-watering recipes including French fries, crispy potato chips, and tasty potato sticks. Whether you’re craving a quick snack or looking to impress with creative cooking hacks, these potato dishes will surely satisfy. Learn step-by-step tips and tricks to make the perfect potato-based treats every time. Elevate your kitchen skills and enjoy the versatile world of potatoes! Don’t forget to like, share, and subscribe for more delicious recipes! 🥔🍴👩‍🍳',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/rbHIj9kMBYY?si=L1bbxumrVg1utbKF',
                'download_status' => 0,
                'download_url' => NULL,
            ],
            [
                'name' => 'Creative 3D Pen Crafts',
                'poster_url' => '/dummy-images/video/creative_3d_pen_crafts.png',
                'poster_tv_url' => '/dummy-images/video/creative_3d_pen_crafts.png',
                'thumbnail_url' => '/dummy-images/video/creative_3d_pen_crafts.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'free',
                'plan_id' => NULL,
                'status' => 1,
                'IMDb_rating' => NULL,
                'duration' => '00:45',
                'release_date' => '2024-09-10',
                'is_restricted' => 1,
                'short_desc' => 'Discover cool DIY ideas, repair tips, and unique jewelry designs using a 3D pen! 🖊️✨',
                'description' => '"Creative 3D Pen Crafts" brings you innovative homemade ideas and practical repair tips using a 3D pen. From crafting intricate DIY jewelry to fixing everyday items, this video showcases versatile techniques and inspiring designs. Learn how to create stunning, personalized pieces and useful tools with just your 3D pen. Perfect for crafters of all skill levels, this guide offers step-by-step instructions and creative inspiration to take your 3D pen projects to the next level. Watch, learn, and get crafting with fun and functional 3D designs! 🖍️💡🎨',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/QVMOq6b7H6Y?si=tO3WX3zUIze96MTb',
                'download_status' => 0,
                'download_url' => NULL,
            ],
            [
                'name' => 'Apartment 75: The Midnight Visitor',
                'poster_url' => '/dummy-images/video/apartment_75_the_midnight_visitor.png',
                'poster_tv_url' => '/dummy-images/video/apartment_75_the_midnight_visitor.png',
                'thumbnail_url' => '/dummy-images/video/apartment_75_the_midnight_visitor.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'paid',
                'plan_id' => 3,
                'status' => 1,
                'IMDb_rating' => NULL,
                'duration' => '01:10',
                'release_date' => '2024-09-17',
                'is_restricted' => 0,
                'short_desc' => 'In Apartment 75, one night becomes a nightmare when an unwelcome guest arrives, turning calm into terror. 🏚️👻',
                'description' => '"Apartment 75: The Midnight Visitor" presents a series of eerie short videos that unravel a night of horror within the confines of a seemingly ordinary apartment. When an unexpected guest arrives, the tranquility of the night is shattered, leading to spine-chilling encounters and escalating terror. Experience the growing sense of dread as the apartment transforms into a haunted realm where every creak and shadow signals impending doom. This collection of videos delves into the fear of the unknown, showcasing how one uninvited visitor can turn a peaceful night into a nightmare. 🕯️🔍😱',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/km3XTmIDeUA?si=ak3GXgPP7NX5D0p1',
                'download_status' => 0,
                'download_url' => NULL,
            ],
            [
                'name' => 'Food Prep Mastery',
                'poster_url' => '/dummy-images/video/food_prep_mastery.png',
                'poster_tv_url' => '/dummy-images/video/food_prep_mastery.png',
                'thumbnail_url' => '/dummy-images/video/food_prep_mastery.png',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => null,
                'access' => 'paid',
                'plan_id' => 4,
                'status' => 1,
                'IMDb_rating' => NULL,
                'duration' => '00:45',
                'release_date' => '2024-09-22',
                'is_restricted' => 0,
                'short_desc' => 'Master food preparation with smart tips on how to cut and store your ingredients like a pro! Maximize freshness and make meal prep a breeze. 🍎🍗🔪',
                'description' => '"Food Prep Mastery" is your ultimate guide to smart food preparation! Learn essential cutting techniques for fruits, vegetables, and meats, while discovering expert tips on how to store your ingredients to keep them fresh and flavorful for longer. Whether you\'re dicing onions, slicing meats, or storing leafy greens, this video will teach you how to streamline your meal prep and improve your kitchen skills. Perfect for both seasoned chefs and beginners, these tricks will help you take your culinary game to the next level. Don\'t miss out—watch, learn, and enjoy easier, fresher meals! 🥦🍅👨‍🍳',
                'enable_quality' => 0,
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/y1ZXkDDvhC4?si=MDRzE3VkpD9HJSKT',
                'download_status' => 0,
                'download_url' => NULL,
            ],
        ];
        if (env('IS_DUMMY_DATA')) {
            foreach ($videos as $key => $video_data) {
                $posterPath = $video_data['poster_url'] ?? null;
                $posterTvPath = $video_data['poster_tv_url'] ?? null;
                $thumbnailPath = $video_data['thumbnail_url'] ?? null;
                $video_data['slug'] = Str::slug($video_data['name']);
                $video = Video::create(Arr::except($video_data, ['poster_url','poster_tv_url','thumbnail_url']));

                if (isset($posterPath)) {
                    $posterUrl = $this->uploadToSpaces($posterPath);

                    if ($posterUrl) {
                        $video->poster_url = extractFileNameFromUrl($posterUrl,'video');
                    }
                }
                if (isset($posterTvPath)) {
                    $posterTvUrl = $this->uploadToSpaces($posterTvPath);
                    if ($posterTvUrl) {
                        $video->poster_tv_url = extractFileNameFromUrl($posterTvUrl,'video');
                    }
                }
                if (isset($thumbnailPath)) {
                    $thumbnailUrl = $this->uploadToSpaces($thumbnailPath);
                    if ($thumbnailUrl) {
                        $video->thumbnail_url = extractFileNameFromUrl($thumbnailUrl,'video');
                    }
                }
                $video->save();
            }

            Schema::enableForeignKeyConstraints();
        }
    }

    private function uploadToSpaces($publicPath)
    {
        $localFilePath = public_path($publicPath);
        $remoteFilePath = 'video/image/' . basename($publicPath);

        if (file_exists($localFilePath)) {
            // Get the active storage disk from the environment
            $disk = env('ACTIVE_STORAGE', 'local');

            if ($disk === 'local') {
                // Store in the public directory for local storage
                Storage::disk($disk)->put('public/' . $remoteFilePath, file_get_contents($localFilePath));
                return asset('storage/' . $remoteFilePath);
            } else {
                // Upload to the specified storage disk
                Storage::disk($disk)->put($remoteFilePath, file_get_contents($localFilePath));
                return Storage::disk($disk)->url($remoteFilePath);
            }
        }

        return false;
    }
}
